import java.util.PriorityQueue;
import java.util.HashSet;
import java.util.ArrayDeque;


public class PrimMST {

static final int INFTY = Integer.MAX_VALUE;
static final int NO_EDGE = -1; 
	
	/**
	*Runs Prim algorithm on a given undirected, weighted graph.
	*This version includes debug statements lines 58-62 for demo purposes.
	*Comment these lines when not required.
	*@return the weight of the minimum spanning tree or -1 if no such tree exists. 
	*@param g the Graph to be searched. Assume that an edge weight of -1 signifies that the edge does not exist.
	**/
	public static int[] getMinSpanningTree(AdjacencyMatrixGraph g) {
		
		// Path represents an entry in the priority queue for Prim's algorithm.
		class Path implements Comparable<Path>
		{
		    public int     vertex;    //vertex in consideration
		    public int     cost;  	  //current cost for this vertex
		    
		    public Path( int v, int c) {
		        vertex = v;
		        cost = c;
		    }
		    
		    public int compareTo( Path rhs ) {
		        double otherCost = rhs.cost;
		        return cost < otherCost ? -1 : cost > otherCost ? 1 : 0;
		    }
		}

		//Prim's algorithm
		int n = g.getNumberOfVertices();
		//state variables for Prim
		int[] visited = new int[n]; //white = 0, grey = 1, black = 2
		int[] key = new int[n]; //edge costs
		int[] p = new int[n]; //pi list of connected vertex
		
		for (int i=1; i<n; i++) {
			visited[i] = 0;
			key[i] = INFTY;
			p[i] = NO_EDGE;
		}
		
		PriorityQueue<Path> pri = new PriorityQueue<>(n); //create a priority queue with capacity n
		int s = 0; //start vertex
		visited[s] = 1; //grey
		key[s] = 0;
		p[s]=NO_EDGE;
		pri.add(new Path(s,key[s]));

		while(!pri.isEmpty()){
			showArray("visited = ",visited);
			showArray("key = ",key);
			showArray("p = ",p);
			showQueue("q = ",pri);
			System.out.println();
			int u = pri.remove().vertex;
			HashSet<Integer> nn = g.getNeighbours(u);
			for (Integer v : nn) {
				if (visited[v]==0) {
					visited[v] = 1;
					key[v] = g.getEdgeWeight(u,v);
					p[v]=u;
					pri.add(new Path(v,key[v]));
				} else if (visited[v]==1) {
					if (key[v] > g.getEdgeWeight(u,v)) {
						key[v] = g.getEdgeWeight(u,v);
						p[v] = u;
					}
				}	
			}
			visited[u] = 2; //black: u is done //is v in pseudo code?
		}
		return(p); //the connected edge for each v
	}

	public static void showArray(String msg, int[] arr) {
		System.out.print(msg);
		for (int i=0; i<arr.length; i++) {
			if (arr[i]==INFTY) {
				System.out.print("infty, ");
			} else {
				System.out.print(arr[i]+", ");
			}
		}
		System.out.println();
	}
	
	public static void showQueue(String msg, PriorityQueue q) {
		System.out.print(msg);
		//TODO
		System.out.println();
	}
	
	/**
	 * demonstration of Prim's algorithm in action
	 * @param args
	 */
	public static void main (String[] args) {
		AdjacencyMatrixGraph g1 = new AdjacencyMatrixGraph(8,true,false); //weighted undirected gr with 8 vertices
		g1.addEdge(0,1,3);
		g1.addEdge(1,2,1);
		g1.addEdge(2,3,2);
		g1.addEdge(2,5,4);
		g1.addEdge(3,6,1);
		g1.addEdge(3,5,3);
		g1.addEdge(4,5,2);
		g1.addEdge(5,6,2);
		g1.addEdge(6,7,1);
		g1.addEdge(7,5,6);
		
		System.out.println(g1.toString()); //show the graph
		
		int[] p = getMinSpanningTree(g1); //run Prim MST
		
		//show the results
		System.out.println("Prim MST result:");
		for (int v=0; v<g1.getNumberOfVertices(); v++) {
			if (p[v] != NO_EDGE) {
				System.out.println("edge=("+ v+ ","+p[v]+") weight=" + g1.getEdgeWeight(v, p[v]));
			}
		}

	}
}
