import java.util.HashSet;

/**
 * some operations to be provided by a graph implementation
 * @author rachelcardell-oliver
 *
 */
public interface GraphADT {

	/**
	 * @return the number of vertices in a graph
	 * vertices are labelled 0 to n-1
	 */
	public int getNumberOfVertices();
	
	/**
	 *Adds an edge of the given weight to the graph.
	 *If the graph is undirected the reverse edge is also added.
	 *If the graph is unweighted the weight is set to one.
	 *If an edge already exists it is overwritten with the new weight.
	 *Only simple graphs allowed (no loop edges v,v)
	 *@param u the start of the edge
	 *@param v the end of the edge
	 *@param weight the weight of the edge
	 **/
	public void addEdge(int u, int v, int weight);
	
	/**
	 * get the weight of given edge of the graph
	 * @param u vertex (start)
	 * @param v vertex (end)
	 * @return weight >= 1 for weighted graph, 
	 * @return 1 for an existing edge in an unweighted graph
	 * @return 0 if no edge exists
	 */
	public int getEdgeWeight(int u, int v);
	
	/**
	 * check whether u,v is an edge in the graph
	 * @param u vertex (start)
	 * @param v vertex (end)
	 * @return boolean true if u,v is an edge, false otherwise
	 */
	public boolean isAdjacent(int u, int v);
	
	/**
	 * get all the neighbours of a given vertex
	 * @param v vertex
	 * @return set of vertex IDs for the neighbours of v
	 */
	public HashSet<Integer> getNeighbours(int v); 
	
	
	
}
