/**
 * Abstract data type (ADT) for a priority queue
 * 
 * @author rachel cardell-oliver
 * @version nov 2015
 */
public interface PriorityQueueADT<T> {

	/* 
	 * The item is placed in front of all elements with
	 * lesser priority, but behind all others.
	 * @param a the item (of type T) to be inserted
	 * @param k the priority of the item
	 */
	public void enqueue(T a, int k); 
	
	public T dequeue(); // remove from the front

	public T examine(); // get value of top element

	public boolean isEmpty(); // test for empty queue
}
