import java.util.HashMap;
import java.util.Collection;
import java.util.Set;

/**
 * demonstration of map class based on Weiss MapDemo code
 * @author Allan Weiss (modified rachelcardell-oliver)
 *
 */
public class MapDemo {

	 public static void printMap( String msg, HashMap<String,String> m )
	    {	 
		 System.out.println(msg);
		 Set<String> keys = m.keySet();
		 Collection<String> vals = m.values();
		 for (String k : keys) {
			 String v = m.get(k);
			 System.out.print( "("+k+","+v+"), " );
		 }
		 System.out.println();
	    }
	 
	public static void main(String[] args) 
    {		
		HashMap<String,String> phone1 = new HashMap<>();

        phone1.put( "John Doe", "212-555-1212" );
        phone1.put( "Jane Doe", "312-555-1212" );
        phone1.put( "Holly Doe", "213-555-1212" ); 
        phone1.put( "Susan Doe", "617-555-1212" ); 
        phone1.put( "Jane Doe", "unlisted" );

        
        System.out.println( "The " + phone1.getClass( ).getName( ) + ": " );
        printMap( "phone1", phone1 );
        
        System.out.println( "phone1.get(\"Jane Doe\") returns: " + phone1.get( "Jane Doe" ) );
        System.out.println( );
        
        System.out.println( "\nThe keys are: " );
        Set<String> keys = phone1.keySet( );
        System.out.println( keys.toString() );
        
        System.out.println( "\nThe values are: " );
        Collection<String> values = phone1.values( );
        System.out.println( values.toString() );
        
        System.out.println( );
        keys.remove( "John Doe" );
        values.remove( "unlisted" );
        System.out.println( "After John Doe (key) and unlisted (value) are removed, the map is" );
        printMap( "phone1", phone1 );
    }	
}
