
public class LinkedPriorityQueue<T> {

	/**
	 * An inner class to hold the element, the successor,
	 * and the priority
	 **/
	private class Link<T> {
		T element;
		int priority;
		Link<T> next;

		public Link(T e, int p, Link<T> n) {
			this.element = e;
			this.priority = p;
			this.next = n;
		}
	}


	// Only one link is required!
	private Link<T> front;

	// Constructor
	public LinkedPriorityQueue() {
		front = null;
	}

	public boolean isEmpty() {
		return front == null;
	}

	/** 
	 * examine the value of the highest priority element (at front)
	 * this operation is O(1)
	 * @return element value of the front element
	 * @throws Exception must be called from try catch
	 */
	public T examine() throws Exception {
		if (!isEmpty()) {
			return (T) front.element;
		} else throw new Exception("Empty Queue");
	}

	/** 
	 * remove highest priority element (at front)
	 * this operation is O(1)
	 * @return element value of the removed element
	 * @throws Exception
	 */
	public T dequeue() throws Exception {
		if (!isEmpty()) {
			T temp = (T) front.element;
			front = front.next;
			return temp;
		} else throw new Exception("Empty Queue");
	}

	/**
	 * To enqueue, we start at the front of the queue and keep moving back until we find
	 * some element of lesser priority, or reach the end of the queue.
	 * We then insert the new element in front of the lesser element.
	 * This operation is O(n)
	 */
	public void enqueue(T e, int p) {
		if (isEmpty() || p > front.priority) {
			front = new Link<T>(e, p, front);
		} else {
			Link<T> l = front;
			while (l.next != null && l.next.priority >= p) {
				l = l.next;
			}
			l.next = new Link<T>(e, p, l.next);
		}
	}

}
