import CITS2200.Overflow;
import CITS2200.Underflow;

/**
*A Class for basic operations of a double ended queue (DEQUE).
*Implements the local DequeADT
*@author Tim French
**/

public class ArrayIntegerDeque implements DequeADT<Integer>{

	int[] items;
	int left;
	int size;

	public ArrayIntegerDeque(int maxSize){
		items = new int[maxSize];
		left = 0;
		size = 0;
	}

	
	/**
	*Adds an element to the right end of the queue.
	*@param element the element to be added
	*@throws overflow if the queue is full
	**/
	public void pushLeft(Integer element) throws Overflow{
		if(isFull()) throw new Overflow("Full!");
		left = (left+items.length-1)%items.length;
		items[left]=element;
		size++;
	}

	/**
	*Adds an element to the left end of the queue.
	*@param element the element to be added
	*@throws overflow if the queue is full
	**/
	public void pushRight(Integer element)throws Overflow{
		if(isFull()) throw new Overflow("Full!");
		items[(left+size++)%items.length]=element;
	}


	/**
	*Removes and returns the element on the left end of the queue.
	*@return the leftmost element
	*@throws Underflow if the queue is empty
	**/
	public Integer popLeft() throws Underflow{
		if(isEmpty()) throw new Underflow("Empty!");
		int o = items[left++];
		left = left%items.length;
		size--;
		return o;
	}

	/**
	*Removes and returns the element on the right end of the queue.
	*@return the rightmost element
	*@throws Underflow if the queue is empty
	**/
	public Integer popRight() throws Underflow{
		if(isEmpty()) throw new Underflow("Empty!");
		size--;
		return items[(left+ size)%items.length];
	}
	
	/**
	*Returns the element on the right end of the queue.
	*@return the rightmost element
	*@throws Underflow if the queue is empty
	**/
	public Integer peekRight() throws Underflow{
		if(isEmpty()) throw new Underflow("Empty!");
		return items[(left+size-1)%items.length];
	}

	/**
	*Returns the element on the left end of the queue.
	*@return the leftmost element
	*@throws Underflow if the queue is empty
	**/
	public Integer peekLeft() throws Underflow{
		if(isEmpty()) throw new Underflow("Empty!");
		return items[left];
	}

	/**
	*@return true is the queue is empty
	**/
	public boolean isEmpty(){return size==0;}

	/**
	*@return true if the queue is full
	**/
	public boolean isFull() {
		 return (size == items.length);
    }

}
