import CITS2200.DuplicateItem;
import CITS2200.ItemNotFound;

/**
 * TODO binary search tree with insert and delete
 * @author  mark allen weiss with modifications by rachelcardell-oliver
 * @version nov 2015
 *
 */
public class BinarySearchTree<T extends Comparable<? super T>> {

	BinaryTreeNode<T> root;

	public BinarySearchTree() {
		root = null;
	}

	public boolean isEmpty() {
		return ( root == null );
	}

	/**
	 * @return item that matches a or null if no match
	 */
	private BinaryTreeNode<T> find(T a, BinaryTreeNode<T> t) {
		if (t == null) { return null; } 
		int whatnext = t.value.compareTo(a);
		if (whatnext == 0) {
			return t;
		} else if ( whatnext < 0 ) {
			return ( find(a, t.left) );
		} else { // whatnext > 0
			return ( find(a, t.right) );
		}
	}

	/**
	 * public find a in main tree
	 * @param a
	 */
	public BinaryTreeNode<T> find(T a) {
		return find(a,root);
	}

	/** 
	 * internal method to find the minimum element in
	 * @param t subtree to be searched
	 * @return reference to the smallest element
	 */
	private BinaryTreeNode<T> findMin( BinaryTreeNode<T> t ) {
		if( t != null )
			while( t.left != null ) t = t.left;
		return t;
	}


	/**  
	 * Insert is fairly straightforward 
	 * perform a search for the element as in find
	 * if the element is found, report duplicate item
	 * if an empty node is reached, insert a new node containing the element
	 */
	public BinaryTreeNode<T> insert(T a, BinaryTreeNode<T> t) {
		if (t == null) { 
			t = new BinaryTreeNode<T>(a,null,null); 
		} else if ( t.value.compareTo(a) < 0 ) {
			t.left = insert(a,t.left);
		} else if ( t.value.compareTo(a) > 0 ) {
			t.right = insert(a,t.right);
		} else { //tried to insert duplicate
			throw new DuplicateItem( a.toString() ); 
		}
		return t;
	}

	/**
	 * Standard insert into the main tree
	 * @param a value to insert
	 */
	public void insert(T a) {
		root = insert(a,root);
	}

	/**
	 * internal method to remove minimum element from a subtree
	 * @param t the root of the subtree
	 * @return
	 */
	private BinaryTreeNode<T> removeMin(BinaryTreeNode<T> t) {
		if (t==null) {
			throw new ItemNotFound("Min not found");
		} else if (t.left != null) {
			t.left = removeMin( t.left );
			return t;
		}  else {
			return t.right;
		}
	}

	/**
	 * remove element a from the tree
	 * @param a
	 * @param t
	 * @return the altered tree t
	 * @throws ItemNotFoundException
	 */
	public BinaryTreeNode<T> remove(T a, BinaryTreeNode<T> t) {
		//if element found at a node with at least one external child 
		//then standard delete
		if( t == null )
			throw new ItemNotFound( a.toString( ) );
		if ( a.compareTo( t.value ) < 0 )
			t.left = remove( a, t.left );
		else if ( a.compareTo( t.value ) > 0 )
			t.right = remove( a, t.right );
		//if we get here we've found a - now remove it
		else if ( t.left != null && t.right != null ) { 
			//case where there are two children
			//1. replace the deleted element with its predecessor 
			//note that the predecessor will always have an empty right child
			//2. delete the predecessor
			t.value = findMin( t.right ).value;
			t.right = removeMin( t.right );
		} else {
			if ( t.left != null ) {
				t =  t.left; 
			} else {
				t = t.right;
			}
		}
		return t;
	}

	/**
	 * Delete an item from the main tree
	 * @param a value to delete
	 */
	public void remove(T a) {
		root = remove(a,root);
	}

}
