/**
 * perform a Bredth First Search over a directed graph
 * @author Created by tim on 14/03/06, modified rachelcardell-oliver 2015
 *
 */


public class BFS {

/**
*Runs a BFS on a given directed, unweighted graph.
*@return an array listing the parent of each vertex 
*in the spanning tree, or -1 is the vertex is not reachable from the start vertex.
*@param g the Graph to be searched
*@param startVertex the vertex on which to start the search
**/
public int[] getConnectedTree(AdjacencyMatrixGraph g, int startVertex){
	if (startVertex >= g.getNumberOfVertices()) {
		throw new RuntimeException("Vertex out of bounds");
	}
	int[] queue  = new int[g.getNumberOfVertices()];
	int head = 0;
	int tail = 0;
	queue[tail++] = startVertex;
	int currentVertex;
	int[] visited = new int[g.getNumberOfVertices()]; //white = 0, grey = 1, black = 2
	int[] spanningTree = new int[g.getNumberOfVertices()];
	for(int i = 0; i<spanningTree.length; i++)spanningTree[i] = -1; 
	while(tail>head){
		currentVertex = queue[head++];
		visited[currentVertex] = 2;
		for(int i = 0; i< g.getNumberOfVertices(); i++){
			if (g.isAdjacent(currentVertex,i) && (visited[i] == 0)){
				visited[i] = 1;
				spanningTree[i] = currentVertex;
				queue[tail++] = i;
			}
		}
	}
	return spanningTree;
} 

/**
*Runs a BFS on a given directed, unweighted graph to find the distances of vertices from the start vertex.
*@return an array listing the distance of each vertex from the start vertex of each, or 
* -1 is the vertex is not reachable from the start vertex.
*@param g the Graph to be searched
*@param startVertex the vertex on which to start the search
**/
public int[] getDistances(AdjacencyMatrixGraph g, int startVertex){
	if(startVertex >= g.getNumberOfVertices()) {
		throw new RuntimeException("Vertex out of bounds");
	}
	int[] queue  = new int[g.getNumberOfVertices()];
	int head = 0;
	int tail = 0;
	queue[tail++] = startVertex;
	int currentVertex;
	int[] visited = new int[g.getNumberOfVertices()]; //white = 0, grey = 1, black = 2
	int[] distances = new int[g.getNumberOfVertices()];
	for(int i = 0;i<distances.length;i++) distances[i] = -1;
	distances[startVertex] = 0;
	while(tail>head){
		currentVertex = queue[head++];
		visited[currentVertex] = 2;
		for(int i = 0; i< g.getNumberOfVertices(); i++){
			if(g.isAdjacent(currentVertex,i) && (visited[i] == 0)){
				visited[i] = 1;
				distances[i] = distances[currentVertex]+1;
				queue[tail++] = i;
			}
		}
	}
	return distances;
} 

}
