public class BinaryTreeNode<T> {

	public T value;  		// data value associated with a node
	public BinaryTreeNode<T> left;  // reference for the left child
	public BinaryTreeNode<T> right; // reference for the right child
	
	//see Weiss Fig 18.12 for a safer implementation 
	// in which these fields are hidden
	// and getter methods and setter methods are used for access
	
	/**
	 * Construct a binary tree node
	 * @param value  data value of type T associated with this node
	 * @param lefttree reference to the left child
	 * @param righttree reference to the right child
	 */
	public BinaryTreeNode( T value, BinaryTreeNode<T> lefttree, 
					BinaryTreeNode<T> righttree ) {
		this.value = value; 
		left = lefttree;
		right = righttree;
	}	
	
	/**
	 * traverse a binary tree in order and
	 * print out the value of each node visited
	 * @param root of the binary tree to start from
	 */
	public void printPreOrder () {
		if (this != null) 
			System.out.println(value.toString()); //visit root
		if (left != null)
			left.printPreOrder();  //visit left
		if (right != null)
			right.printPreOrder(); //visit right
		
	}
	
	public void printPostOrder () {
		//TODO write your code here
	}

	public void printInOrder () {
		//TODO write your code here
	}
}
