

/**
 * Utility class offering several sorting algorithms
 */

public class SortingAlgorithmsWithDebug {	
	/**
	 * Executes the insertion sort algorithm sorting the argument 
	 * array. There is no return since the parameter is mutated.
	 * 
	 * @param a the array of short integers to be sorted
	 **/
	public static void insertionSort(short[] a) {
		for (int j = 1; j < a.length; j++) {
			short key = a[j];
			int i = j - 1;
			while (i >= 0 && a[i] > key) {
				a[(i + 1)] = a[i];
				i = i - 1;
			}
			a[i + 1] = key;
		}
	}

	/**
	 * Execute the selection sort algorithm on an argument array. 
	 * There is no return as the parameter is mutated.
	 * @param a	the array of short (numbers) to be sorted
	 **/
	public static void selectionSort(short[] a) {
		//build the sorted portion from 0 upwards
		for (int i = 0; i < a.length - 1; i++) {
			//initialise the minimum value and its position
			short min = a[i];
			int minpos = i;
			//search the unsorted part for its smallest element
			for (int j = i + 1; j < a.length; j++) { 
				if (a[j] < min) {
					min = a[j];
					minpos = j;
				}
			}
			if (i != minpos) {  // swap min into place if necessary
				short temp = a[i]; //copy
				a[i] = a[minpos]; //transfer
				a[minpos] = temp; //replace
			}
		}
	}

	private static boolean demo = true;  //explain merge sort
	//use demo = false; (default) to turn off explanations for mergesort

	/**
	 * Executes the merge sort algorithm sorting the argument array. 
	 * There is no return as the parameter is to be mutated.
	 * 
	 * @param a the array of short integers to be sorted
	 **/
	public static void mergeSort(short[] a) {
		mergeSort(a, 0, a.length-1);
	}

	private static void mergeSort(short[] a, int l, int r) {
		if (l < r) {
			if (demo) { System.out.println("merge sort "+l+" to "+r); }
			int mid = (l + r) / 2;
			mergeSort(a, l, mid);
			mergeSort(a, mid + 1, r);
			merge(a, l, mid, r);
		}	
	}

	/**
	 * Merge two parts of array a from l to mid and mid+1 to r inclusive
	 * @param a the array containing the portions for merging
	 * @param l left index, used for portion 1 from l to mid
	 * @param mid mid index, user for portion 2 from mid+1 to r
	 * @param r right index
	 */
	private static void merge(short[] a, int l, int mid, int r) {
		int lsize = mid - l + 1;
		int rsize = r - mid;
		short[] left = new short[lsize];
		short[] right = new short[rsize];

		for (int i = 0; i < lsize; i++) {
			left[i] = a[l + i];
		}
		for (int j = 0; j < rsize; j++) {
			right[j] = a[mid + 1 + j];
		}
		int i = 0;
		int j = 0;
		int k = l;
		while (i < lsize && j < rsize) {
			if (left[i] < right[j]) {
				a[k++] = left[i++];
			} else {
				a[k++] = right[j++];
			}	
		}
		while ( i < lsize ) { // Copy rest of first half
			a[k++] = left[i++];
		}
		while( j < rsize ) { // Copy rest of second half
			a[k++] = right[j++];
		}
		if (demo) { //print out for demo only
			for (i=l; i<=r; i++) { System.out.print(a[i]+","); }
			System.out.println(" from merging "+l+" to "+mid
					+" and "+(mid+1)+" to " +r);
		}

	}

	/**
	 * Execute the quicksort algorithm sorting the argument array. There is no
	 * return as the parameter is to be mutated.
	 * 
	 * @param a
	 *            the array of short integers to be sorted
	 **/
	public static void quickSort(short[] a) {
		quickSort(a, 0, a.length - 1);
	}

	/**
	 *A private method to partition the array a, between the indices p and r,
	 * inclusive. The method selects the element a[r] as the pivot.
	 * 
	 * @param a the array to be sorted, which is mutated by the method
	 *@param p the lower index of the range to be partitioned
	 *@param r the upper index of the range to be paritioned
	 *@return the index of the point of partition
	 **/
	private static int partition(short[] a, int p, int r) {
		short pivot = a[r]; // set pivot to be the value of the rightmost element
		int wall = p - 1; //position the wall at the left of p
		for (int j = p; j <= r; j++) { // j=p is the lower index
			if (a[j] <= pivot) { // if a[j] < pivot then swap it to the other side of the fence
				wall++;  		//move the wall right
				short temp = a[j]; //copy
				a[j] = a[wall]; 	//transfer
				a[wall] = temp;		//restore
			}
		}
		return wall; //final position of the wall
	}

	public int partition(int[] a, int start, int finish) {
		int fence = a[start]; //get the pivot value
		int left = start+1;
		int right = finish;
		while (right >= left) {
			while (left <= right && a[left] <= fence) 
				left++;
			while (right >= left && a[right] >= fence)
				right--;
			if (right > left) {
				int swap = a[left];
				a[left] = a[right];
				a[right] = swap;
			}
		}
		a[start] = a[right];
		a[right] = fence;

		return right; //return position of the fence
	}


	/**
	 *Overloads the quickSort method with parameters to set the range to be sorted.
	 **/
	private static void quickSort(short[] a, int p, int r) {
		if (p < r) {
			int q = partition(a, p, r);
			quickSort(a, p, q - 1);
			quickSort(a, q + 1, r);
		}
	}

}
