/**
 * Three search algorithms
 * Sequential and Step with
 * Binary search from Weiss Fig 5.11
 */
public class SearchAlgorithms {

  public static int NOT_FOUND = -1;
  public static boolean DEMO = true; //true to print debug statements

  /**
   * search for an item in an array this is the slowest search,
   * O(N) but also the simplest
   *
   * @param a array to be searched, assumed to be sorted
   * @param key item being searched for
   * @return index of key in a if key is found, and NOT_FOUND otherwise
   */
  public static int SequentialSearch(int[] a, int key) {
    for (int i = 0; i < a.length; i++) {
      if (DEMO) { System.out.println("Testing position "+i); }
      if (a[i] == key) { // found it!
        return i;
      }
    }
    return NOT_FOUND; // if we get here, the item was not found
  }

  /**
   * step search for an item in an array
   * this is slightly faster than sequential search but still O(N)
   *
   * @param a array to be searched, assumed to be sorted
   * @param key item being searched for
   * @param step step size for moving through array
   * @return index of key in a if key is found, and NOT_FOUND otherwise
   */
  public static int StepSearch(int[] a, int key, int step) {
    int i = 0;
    while (i < a.length) {
      if (DEMO) { System.out.println("Testing position "+i); }
      if (a[i] == key) { // found it
        return i;
      }
      if (a[i] < key) { // flip forwards
        i = Math.min(i + step, a.length - 1);
      } else { // search back through the block
        for (int j = i - 1; j > i - step; j--) {
          if (DEMO) { System.out.println("Testing position "+j); }
          if (a[j] == key) {
            return j;
          }
        }
        return NOT_FOUND;
      }
    }
    return NOT_FOUND; // if we get here, the item was not found
  }

  /**
   * Binary search to find key in array a is O(log N)
   *
   * @param a array to be searched, assumed to be sorted
   * @param key item being searched for
   * @return index of key in a if key is found, and NOT_FOUND otherwise
   */
  public static int BinarySearch(int[] a, int key) {
    int low = 0;
    int high = a.length - 1;
    int mid;

    while (low <= high) {
      mid = (low + high) / 2;
      // more generally ( a[ mid ].compareTo( x ) < 0 )
      if (DEMO) { System.out.println("Testing position "+mid); }
      if (a[mid] < key) { // continue to search lower part
        low = mid + 1;
      } else if (a[mid] > key) { // continue to search upper part
        high = mid - 1;
      } else { // we've found it
        return mid;
      }
    }
    // if we get here, the item was not found
    return NOT_FOUND; // NOT_FOUND = -1
  }

  /**
   * test code
   */
  public static void main(String[] args) {
    //some test cases to see binary search at work
    int[] a = new int[] { 11, 102, 223, 254, 265, 306, 367, 388, 399, 1000 };
    int[] testkeys = new int[] { 265, 388, 1000, 200 };
    for (int key : testkeys) {
      if (DEMO) { System.out.println("Sequential Search for "+key); }
      int res1 = SequentialSearch(a, key);
      if (DEMO) { System.out.println("Step Search for "+key); }
      int res2 = StepSearch(a, key, 3);
      if (DEMO) { System.out.println("Binary Search for "+key); }
      int res3 = BinarySearch(a, key);
      System.out.println("Found key = " + key + " at position " +
            res1 + "," + res2 + "," + res3);
    }
  }

}
