
## Queue

Things our class must be able to do:

- public void enqueue(String newEl)
- public String dequeue()
- constructor:
  - head: null
  - tail: null
  - size: 0

- isEmpty()
     is size == 0?

- getSize():
    return size

- dequeue method:
  what does it need to do?

   check - is the queue empty?
   if the queue is empty - signal an error

   store the value from the head of the queue
   -- later we will return this to the user

   adjust where head points to --
   when we remove the first element of the queue,
   the head should now point to the *second* element.

- enqueue method: what does it need to do?

  - do we need to check whether full? no, no maximum
    capacity
  - we need to create a new ListNode
  - we need to make the old tail node point to the new node
  - we need to make "tail" point to our new node


## Linked list operations

- How can we insert elements into the middle of a linked list?
- (And - how can we delete elements from the middle of a linked list?)

Inserting a new element

- We have a list: with elements 1, 2, 3 and 4
- and we wish to insert the new element "99"
  between 2 and 3.

things we need to do:

- ListNode newNode = ListNode(99);
- before.next is useful -- it tells us the old "next" node
 
- newNode.next = before.next
- before.next = newNode

If we are inserting into the middle of a list,
we need a reference to the node _before_
the spot where our new node goes.

Maybe a user has said -- "search for an element
whose value is 2, and insert the new node there"


- assume "before" is the start of our list
- while (before.value != 3) {
    before = before.next;
  }

- before.next = before.next.next

Big "O":

- Algorithm A has complexity O(n)

- We can't take an algorithm - say your sorting
 algorithm you say is fast - and say "it takes 3 milliseconds"

- function: that takes IN the size of the input
  and spits out how long the algorithm takes

On your fast computer, we use your sorting
algorithm:
   
- running_time(n): 200ms * n^2 + 10ms.

On my slow computer, we use your sorting
algorithm:

- running_time(n): 400ms * n^2 + 20ms.

From calculus we would know ...

As n gets bigger and bigger, 
As n tends towards infinity,
"+10ms" is unimportant.

Definitely read the textbook as well!


running_time(1000000)
running_time(2000000)

Time to count length of string:

- running_time(n): n + 4ms

running_time(10000) = 1000004
running_time(20000) = 2000004

As n tends towards infinity:

Your new string-counting algorithm
has "linear complexity"
OR It has O(n) complexity



Imagine we have f(x)

When may we say, "f(x) has order of complexity g(x)"


running_time(n)

g(x) the way we want to *describe* f(x).

g(x) = 100x + 12

g(x) = 50 x^5 +  + 32


running_time of our string-length algorithm

- We would like to say: g(n) = n
- And it is true, that, beyond a certain size n,
  f(n) <= C * g(n)

let our constant C = 2

f(n) = 14 + n

We are allowed to say that g(n)

---

When we say the complexity of our algorithm
is O(n^3)

----

string-counting:
- running time roughly increases in proportion
to input size
O(n)

Whenever we make a new string:
   record its length

A new string 

   new_string = old_string_1 + old_string_2

How long to work out length of a string?

- Using our new system ...
  KnownLengthString myBigStringThing =  ....

  int length = myBigStringThing.strLength

----

What is the complexity of the new
string-length algorithm?

- g(n) : actual running time f(n), 
    beyond a certain point n_0:
      f(n) <= C * g(n)

- g(n) = 1
  There IS some value C -- namely C = 2
  There IS some point in the graph of running time
  2 * g(n)

-  has complexity: O(1)
O(n)
O(n^2)



## THURSDAY

- slide: "Complexity of our new string-length algorithm"

- if you have questions about "big O" - ask them!

- work through Big O problems on the problem sheet

- more on debugging




























