
Hi everybody, my name is Arran Stewart
and I'm the lecturer for Data Structures 
and Algorithms.

We will wait a few minutes to make sure people in the classroom can hear okay and have access to the Zoom session.

You can see I have open a website
https://teaching.csse.uwa.edu.au/units/DSA-SWU/

where I have put copies of lecture slides. I believe you also will have copies on one of your own sites.

Sorry to people who are all ready to go --
we will wait a few minutes more, I will check with Yangming in a few minutes how the classroom is going.

## Implementing a stack

- push: We need to able to insert elements (at the top))
- pop: We need to be able to remove elements (from the top)

Assume that we will store ints

Our operations are

-  public void push( int x ), inserting an element
-  public void pop(), removing an element

-  public boolean isEmpty()
-  public boolean isFull()
-  public int top()

We need to be able to create a new stack

- public Stack()


We need variables to store our data:

int[] stack;

All of these are inside a class:

public class Stack

-----

How will we write them?

- constructor:
  - initialize the array
  - set topOfStack = -1

- isEmpty() operation:
  - is topOfStack == -1?

- isFull() operation:
  - is topOfStack + 1 == CAPACITY

- int top() operation: say what the current top value is

- push(int x) operation
  - if the stack is full, signal an error
  - otherwise:
    - increment topOfStack
    - write a new value into the array

- pop() operation
  - if the stack is empty, signal an error
  - otherwise:
    - decrement topOfStack 

## Array-based implementations:

- Disadvantage: maximum capacity is fixed
- Advantage: very fast to look up elements


## Queues

What operations must be supported?

- isFull()
- isEmpty()

- constructor: initialize variables in our queue

Constructor:

- allocate a new array
- set "head" equal to something - we will use 0
- set "length" equal to 0

boolean isFull() operation:
- return whether length is equal to CAPACITY

boolean isEmpty() operation:
- return whether length is equal to zero


- enqueue(int item): add something to the back/tail
  - check if the queue is already full -- if full, signal an error
  - (head + 1) % CAPACITY

CAPACITY = 4

Suppose head = 0.
What is (head + 1) % CAPACITY?
(0 + 1) % 4
1 % 4
1

Suppose head = 1.
What is (head + 1) % CAPACITY?
(1 + 1) % 4
2 % 4
2

Suppose head = 3.
What is (head + 1) % CAPACITY?
(3 + 1) % 4
4 % 4
0

Suppose head = 4.
What is (head + 1) % CAPACITY?
(4 + 1) % CAPACITY
5 % CAPACITY
5 % 4
1


- dequeue: remove something from the head/front

- first: check whether the queue is empty.
  - If already empty, signal an error

- we increment head by 1; but if it reaches the end of the array, "wrap around"
































