import CITS2200.Overflow; 
import CITS2200.Underflow; 
/**
*A Class for basic operations of a double ended queue (DEQUE).
*@author Tim French
**/

public interface DequeADT<E>{
	
	/**
	*Adds an element to the left end of the queue.
	*@param element the element to be added
	*@throws overflow if the queue is full
	**/
	public void pushLeft(E element) throws Overflow;

	/**
	*Adds an element to the right end of the queue.
	*@param element the element to be added
	*@throws overflow if the queue is full
	**/
	public void pushRight(E element) throws Overflow;

	/**
	*Removes and returns the element on the left end of the queue.
	*@return the leftmost element
	*@throws Underflow if the queue is empty
	**/
	public E popLeft() throws Underflow;

	/**
	*Removes and returns the element on the right end of the queue.
	*@return the rightmost element
	*@throws Underflow if the queue is empty
	**/
	public E popRight() throws Underflow;

	/**
	*Returns the element on the right end of the queue.
	*@return the rightmost element
	*@throws Underflow if the queue is empty
	**/
	public E peekRight() throws Underflow;

	/**
	*Returns the element on the left end of the queue.
	*@return the leftmost element
	*@throws Underflow if the queue is empty
	**/
	public E peekLeft() throws Underflow;

	/**
	*@return true is the queue is empty
	**/
	public boolean isEmpty();

	/**
	*@return true if the queue is full
	**/
	public boolean isFull();

}
