

/**
 * Utility class offering several sorting algorithms
 */

public class SortingAlgorithms {	
	/**
	 * Execute the insertion sort algorithm sorting the argument 
	 * array. There is no return since the parameter is mutated.
	 * 
	 * @param arr the array of short integers to be sorted
	 **/
	public static void insertionSort(short[] arr) {
		for (int j = 1; j < arr.length; j++) {
			short key = arr[j];
			int i = j - 1;
			while (i >= 0 && arr[i] > key) {
				arr[(i + 1)] = arr[i];
				i = i - 1;
			}
			arr[i + 1] = key;
		}
	}

	/**
	 * Execute the selection sort algorithm on an argument array. 
	 * There is no return as the parameter is mutated.
	 * @param arr	the array of short (numbers) to be sorted
	 **/
	public static void selectionSort(short[] arr) {
		//build the sorted portion from 0 upwards
		for (int i = 0; i < arr.length - 1; i++) {
			//initialise the minimum value and its position
			short min = arr[i];
			int minpos = i;
			//search the unsorted part for its smallest element
			for (int j = i + 1; j < arr.length; j++) { 
				if (arr[j] < min) {
					min = arr[j];
					minpos = j;
				}
			}
			if (i != minpos) {  // swap min into place if necessary
				short temp = arr[i]; //copy
				arr[i] = arr[minpos]; //transfer
				arr[minpos] = temp; //replace
			}
		}
	}

	
	
	
	
	
	/**
	 * Execute the merge sort algorithm sorting the argument array. 
	 * There is no return as the parameter is to be mutated.
	 * @param arr the array of short integers to be sorted
	 **/
	public static void mergeSort(short[] arr) {
		mergeSort(arr, 0, arr.length-1);
	}

	private static void mergeSort(short[] arr, int l, int r) {
		if (l < r) {
			int mid = (l + r) / 2;
			mergeSort(arr, l, mid);
			mergeSort(arr, mid + 1, r);
			merge(arr, l, mid, r);
		}	
	}

	/**
	 * Merge two parts of array arr from l to mid and mid+1 to r inclusive
	 * @param arr the array containing the portions for merging
	 * @param l left index, used for portion 1 from l to mid
	 * @param mid mid index, user for portion 2 from mid+1 to r
	 * @param r right index
	 */
	private static void merge(short[] arr, int l, int mid, int r) {
		int lsize = mid - l + 1;
		int rsize = r - mid;
		short[] left = new short[lsize];
		short[] right = new short[rsize];

		for (int i = 0; i < lsize; i++) {
			left[i] = arr[l + i];
		}
		for (int j = 0; j < rsize; j++) {
			right[j] = arr[mid + 1 + j];
		}
		int i = 0;
		int j = 0;
		int k = l;
		while (i < lsize && j < rsize) {
			if (left[i] < right[j]) {
				arr[k++] = left[i++];
			} else {
				arr[k++] = right[j++];
			}	
		}
		while ( i < lsize ) { // Copy rest of first half
			arr[k++] = left[i++];
		}
		while( j < rsize ) { // Copy rest of second half
			arr[k++] = right[j++];
		}
	}

	/**
	 * Execute the quicksort algorithm sorting the argument array. 
	 * There is no return as the parameter is to be mutated.
	 * @param arr the array of short integers to be sorted
	 **/
	public static void quickSort(short[] arr) {
		quickSort(arr, 0, arr.length - 1);
	}
	
	/**
	 *Overloads the quickSort method with parameters to set the range to be sorted.
	 **/
	private static void quickSort(short[] arr, int p, int r) {
		if (p < r) {
			int q = partition(arr, p, r);
			quickSort(arr, p, q - 1);
			quickSort(arr, q + 1, r);
		}
	}

	/**
	 *A private method to partition the array arr, 
	 * between the indices start and finish inclusive
	 * inclusive. The method selects the element arr[r] as the pivot.
	 * 
	 * @param arr the array to be sorted, which is mutated by the method
	 *@param p the lower index of the range to be partitioned
	 *@param r the upper index of the range to be paritioned
	 *@return the index of the point of partition
	 **/
	public static int partition(short[] arr, int start, int finish) {
		short fence = arr[start]; //get the pivot value
		int left = start+1;
		int right = finish;
		while (right >= left) {
			while (left <= right && arr[left] <= fence) 
				left++;
			while (right >= left && arr[right] >= fence)
				right--;
			if (right > left) {
				short swap = arr[left];
				arr[left] = arr[right];
				arr[right] = swap;
			}
		}
		arr[start] = arr[right];
		arr[right] = fence;

		return right; //return position of the fence
	}




}
