import CITS2200.Overflow; //exception classes for error cases
import CITS2200.Underflow; 

public class Stack {

  public static int CAPACITY = 4; // default size for demo

  int[] stack;        // stores objects in a stack
  int topOfStack;     // index of the most recently added element

  /**
   * create an empty stack of default CAPACITY
   */
  public Stack() {
    stack = new int[CAPACITY];
    topOfStack = -1;
  }

  /**
   * @return true if the stack is empty or false otherwise
   */
  public boolean isEmpty() {
    return topOfStack == -1;
  }
  
  /**
   * @return true if the stack is full or false otherwise
   */
  public boolean isFull() {
    return topOfStack + 1 == CAPACITY;
  }


  /**
   * Get the most recently inserted item in the stack.
   * Does not alter the stack.
   * @return the most recently inserted item in the stack.
   * @throws Underflow exception if the stack is empty.
   */
  public int top() {
    if (isEmpty()) {
      throw new Underflow( "Stack empty so can not top" );
    }
    return stack[topOfStack];
  }
  
  /**
   * Remove the most recently inserted item from the stack
   * @throws Underflow exception if the stack is empty
   */
  public void pop() {
    if (isEmpty()) {
      throw new Underflow( "Stack empty so can not pop" );
    }
    topOfStack = topOfStack - 1;
  }
  
  /**
   * Insert a new item into the stack
   * @param x the item to insert
   */
  public void push( int x )
  {
      if( isFull() ) {
        throw new Overflow( "Stack full so can not push " );
      }
      topOfStack = topOfStack + 1;
      stack[ topOfStack ] = x;
  }
}
