import CITS2200.Overflow; //exception classes for error cases
import CITS2200.Underflow;

public class Queue {

	public static int CAPACITY = 4; 	// default queue capacity for demo

	int[] queue; 	// stores objects in a queue
	int head; 		// index of the head element
	int length; 	// number of objects in the queue

	/**
	 * create an empty queue of default CAPACITY
	 */
	public Queue() {
		queue = new int[CAPACITY];
		head = 0;
		length = 0;
	}

	/**
	 * @return true if the queue is empty, false otherwise
	 */
	public boolean isEmpty() {
		return length == 0;
	}

	/**
	 * @return true if the queue is full, false otherwise
	 */
	public boolean isFull() {
		return length == CAPACITY;
	}

	/**
	 * add a new item to the queue if there is space
	 * @param item the item to add
	 * @throws Overflow exception if the stack is full
	 */
	public void enqueue(int item) {
		if (isFull()) {
			throw new Overflow("Queue full so can not enqueue");
		}
		queue[(head + length) % CAPACITY] = item;
		length = length + 1;
	}

	/**
	 * remove the head item in the queue
	 * @return the head item value if available
	 * @throws Underflow exception if the stack is empty
	 */
	public int dequeue() {
		if (isEmpty()) {
			throw new Underflow("Queue empty so can not dequeue");
		}
		int item = queue[head];
		head = (head + 1) % CAPACITY;
		length = length - 1;
		return (item);
	}
}