import CITS2200.Underflow;

public class LinkedListStringQueue   {

    private ListNode<String> head;   // reference to the head of the queue
    private ListNode<String> tail;   // reference to the tail of the queue
    private int size;     // number of objects in the queue

    /**
     * create an empty queue
     */
    public LinkedListStringQueue() {
      head = null;
      tail = null;
      size = 0;
    }

    /**
     * add a new item to the queue
     * @param item the item to add
     */
    public void enqueue(String a) {
      ListNode<String> newnode = new ListNode<String>(a);
      if (isEmpty()) {
        head = newnode;
      } else {
        tail.next = newnode;
      }
      tail = newnode;
      size = size + 1;
    }

    /**
     * remove the head of the queue and return its value
     * @return the head item value if available
     * @throws Underflow exception if the queue is empty
     */
    public String dequeue() {
      if (isEmpty()) {
        throw new Underflow("Queue empty so can not dequeue");
      }
      String item = head.value;
      head = head.next;
      size = size - 1;
      return (item);
    }

    /**
     * return the value of the head of the queue
     * @throws Underflow exception if the queue is empty
     */
    public String examine() {
      if (isEmpty()) {
        throw new Underflow("Queue empty so can not dequeue");
      }
      return(head.value);
    }

    /**
     * @return true if the queue is empty, false otherwise
     */
    public boolean isEmpty() {
      return size == 0;
    }

    /**
     * @return size of the if the queue is empty
     */
    public int getSize() {
      return size;
    }

    /**
     * Print contents of the queue to System.out
     */
    public void printQueue() {
      if (size > 0) {
        System.out.println("Queue is empty");
      } else {
        System.out.println("Queue has "+ size +"elements:");
        ListNode<String> q = head;
        while (q != null) {
          System.out.println(q.value);
          q = q.next;
        }
      }
    }

}

