
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Color;
import java.util.Scanner;

@SuppressWarnings("serial")
public class FractalStar extends Frame
{
	private static final int theSize = 256;
    private static boolean isdemo = true; //true;  //wait for user input return at each step, FALSE to run without waiting
    public static int stopval = 8; //default is 1, but if isdemo then stop earlier 
    private static Scanner in; //wait for user input to view recursive steps

    public void paint( Graphics g )
    {
        g.setColor( Color.white);
        g.fillRect(20, 20, theSize , theSize ); //fill background
        g.setColor( Color.blue );
        drawSpace( g, theSize / 2 + 20 , theSize / 2 + 20 , theSize );
    }

    private void drawSpace( Graphics g, int xCenter, int yCenter, int boundingDim )
    {
        int side = boundingDim / 2;

        
        if( side < stopval) { // 8 for demo purposes, 1 for full run 
        	  return;
        }
          
        
        int left =   xCenter - side / 2;
        int top =    yCenter - side / 2;
        int right =  xCenter + side / 2;
        int bottom = yCenter + side / 2;
        
        drawSpace( g, left, top, boundingDim / 2 );
        drawSpace( g, left, bottom, boundingDim / 2 );
        drawSpace( g, right, top, boundingDim / 2 ); 
        drawSpace( g, right, bottom, boundingDim / 2 );

        if (isdemo) {
        	in.nextLine(); //wait for user input to continue
        }
        
        g.fillRect( left, top, right - left, bottom - top );
        
    }

    // Simple test program
    // For simplicity, must terminate from console
	public static void main(String[] args)
    {
		if (isdemo) {
			stopval = 8; 
		} else {
			stopval = 1;
		}
		if (isdemo) {
			in = new Scanner( System.in );
			System.out.println("Press return to advance the recursion");
			in.nextLine(); //wait for user input to continue
		}
        Frame f = new FractalStar( );
        f.setSize( theSize + 40, theSize + 40 );
        f.setVisible( true );
    }
}

