import static org.junit.Assert.assertEquals;
import org.junit.Test;

import org.junit.runners.MethodSorters;
import org.junit.FixMethodOrder;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)

public class SortingAlgorithmsTest {

	/** Populate an array a with random integers in the range 0 to 10,000
     * @param a the array to be filled
     */
    private void populate(short[] a) 
    {
        for (int i = 0; i < a.length; i++) {
            a[i] = (short)(10000 * Math.random());
        }
    }

    /**
     * Helper method to check whether array a is sorted
     * @param a array of ints to be checked
     * @return boolean whether array is sorted or not
     */
    private boolean issorted(short[] a) 
    {
        for (int i = 1; i < a.length; i++) {
            if (a[i - 1] > a[i]) { 
                return false; 
            }
        }
        return true;
    }
    
    /**
     * Four helper methods to run test different sort methods
     * @param size  size of array to be generated and sorted
     * @param repeats number of times to repeat the operation
     */
    private void testSelectionSort(int size, int repeats)
    { 
        short[] test = new short[size];
        for (int i = 0; i < repeats; i++) {
            populate(test);
            SortingAlgorithms.selectionSort(test);
            assertEquals(true,issorted(test)); 
        }
    }
    
    private void testInsertionSort(int size, int repeats)
    { 
        short[] test = new short[size];
        for (int i = 0; i < repeats; i++) {
            populate(test);
            SortingAlgorithms.insertionSort(test);
            assertEquals(true,issorted(test)); 
        }
    }
    
    private void testQuickSort(int size, int repeats)
    { 
        short[] test = new short[size];
        for (int i = 0; i < repeats; i++) {
            populate(test);
            SortingAlgorithms.quickSort(test);
            assertEquals(true,issorted(test)); 
        }
    }
    
    private void testMergeSort(int size, int repeats)
    { 
        short[] test = new short[size];
        for (int i = 0; i < repeats; i++) {
            populate(test);
            SortingAlgorithms.mergeSort(test);
            assertEquals(true,issorted(test)); 
        }
    }
    
    @Test public void test1SelectionSort() 
    {
        testSelectionSort(10000,50);
    }
    
    @Test public void test2InsertionSort() 
    {
        testInsertionSort(10000,50);
    }
    
    @Test public void test3MergeSort() 
    {
        testMergeSort(10000,50);
    }
    
    @Test public void test4QuickSort() 
    {
        testQuickSort(10000,50);
    }
    
    
    /*
    @Test public void testSimpleMergeSort() 
    {
    	    short[] test = new short[] { 23, 42, 16, 10, 2, 8 };
        SortingAlgorithms.mergeSort(test);
        assertEquals(true,issorted(test));
    }
    */

}
