# Contributing

When contributing to this repository, please first discuss the change you wish
to make via issue, pull request, or any other method with the owners of this
repository before making a change.

Please note we have a [code of conduct][code-of-conduct],
please follow it in all your interactions with the project.

## Commit messages

Please follow the [Angular commit style][angular-commit-style].
This helps the team automate [CHANGELOG.md][changelog] generation.

## Pull Request Process

1. Update the README.md or similar documentation with details of changes you
   wish to make, if applicable. 
2. Add any appropriate tests.
3. Make your code or other changes.
4. Review guidelines such as
   [How to write the perfect pull request][github-perfect-pr], thanks!


[angular-commit-style]: https://github.com/angular/angular.js/blob/master/DEVELOPERS.md#commits
[changelog]: CHANGELOG.md
[code-of-conduct]: CODE_OF_CONDUCT.md
[github-perfect-pr]: https://blog.github.com/2015-01-21-how-to-write-the-perfect-pull-request/
[mdb-core-values]: https://www.mongodb.com/company/
