#!/bin/bash

CNET="/usr/local/bin/cnet"
export CNETPATH="/usr/local/lib/cnet"

TOPOLOGIES="FLOODING1 FLOODING2 FLOODING3"

HTML="plot.html"

#  CHOOSE ONE OF THESE 3 LINES  (or the last will be used)
METRIC="Messages delivered"	; YTITLE="number of messages delivered"
METRIC="Frames transmitted"	; YTITLE="number of frames transmitted"
METRIC="Efficiency"		; YTITLE="%age delivery efficiency (bytes AL/PL)"

DURATION="20minutes"
EVERY="30"
XTITLE="seconds"

TITLE="A comparison of flooding protocols over $DURATION"

# --  nothing needs changing below this line  --------------------------

cleanup() {
    rm -f tmp.*
}

run_simulations() {
    for t in `echo $TOPOLOGIES`
    do
	$CNET -WFgqz -e $DURATION -f ${EVERY}secs $t	| \
	grep -i "$METRIC"				| \
	cut -d: -f 2					| \
	awk "{ printf(\"%d %s\n\", ++i * $EVERY, \$1); }"	> tmp.$t
    done
}

collate_stats() {
    echo 'data.addRows(['

    T0=`echo " " $TOPOLOGIES | sed -e 's/ / tmp./g' | cut '-d ' -f3-`
    T1=`echo $T0 | cut '-d ' -f1`
    T2=`echo $T0 | cut '-d ' -f1,2`

    if [ "$T0" == "$T1" ]
    then
	CMD="cat $T0"
    elif [ "$T0" == "$T2" ]
    then
	CMD="join $T0"
    else
	CMD="join "`echo $T0 | cut '-d ' -f1`
	CMD="$CMD "`echo $T0 | cut '-d ' -f2- | sed 's/ / | join - /g'`
    fi

    eval $CMD | sed -e 's/ /, /g' -e 's/.*/  [&],/'
    echo ']);'
}

add_titles() {
    echo "      data.addColumn('number', 'seconds');"
    for t in `echo $TOPOLOGIES`
    do
        echo "      data.addColumn('number', '$t');"
    done
}

build_html() {
    cat << END_TOP_SECTION
<html>
<head>
  <script type='text/javascript' src='https://www.gstatic.com/charts/loader.js'></script>
</head>

<body>
  <script type='text/javascript'>
    google.charts.load('45', {'packages':['corechart']});

    function plot1() {
      var data = new google.visualization.DataTable();
END_TOP_SECTION

add_titles
run_simulations
collate_stats | sed 's/^/      /'
cleanup

cat << END_BOTTOM_SECTION
      var options = {
	  title:  '$TITLE',
	  height: 400,
	  width:  800,
	  chartArea: {backgroundColor: '#f2f2f2', left:100, right:160, top:40, bottom:60 },
	  lineWidth: 2,
	  hAxis: { title: '$XTITLE', gridlines: {count: 5} },
	  vAxis: { title: '$YTITLE', format: '0', minValue: 0, gridlines: {count: 10} }
      };
      var container = document.getElementById('myplot');
      var chart     = new google.visualization.LineChart(container);
      chart.draw(data, options);
    }
    google.setOnLoadCallback(plot1);
  </script>

  <div id='myplot'></div>
</body>
</html>
END_BOTTOM_SECTION
}

# ----------------------------------------------------------------------

build_html > $HTML
echo "output is in $HTML"

