#include <cnet.h>

#define	MAXHOPS		4

typedef enum    	{ NL_DATA=0, NL_ACK }   NL_PACKETKIND;

typedef struct {
    CnetAddr		src;
    CnetAddr		dest;
    NL_PACKETKIND	kind;      	// only ever NL_DATA or NL_ACK
    int			seqno;		// 0, 1, 2, ...
    int			hopcount;
    size_t		length;       	// the length of the msg portion only
    char		msg[MAX_MESSAGE_SIZE];
} NL_PACKET;

#define PACKET_HEADER_SIZE	(sizeof(NL_PACKET) - MAX_MESSAGE_SIZE)
#define PACKET_SIZE(p)		(PACKET_HEADER_SIZE + p.length)
#define	ALL_LINKS		(-1)


extern	void	reboot_NL_table(void);

extern	int	NL_ackexpected(CnetAddr address);
extern	int	NL_nextpackettosend(CnetAddr address);
extern	int	NL_packetexpected(CnetAddr address);

extern	void	inc_NL_packetexpected(CnetAddr address);
extern	void	inc_NL_ackexpected(CnetAddr address);

extern	int	NL_linksofminhops(CnetAddr address);
extern	void	NL_savehopcount(CnetAddr address, int hops, int link);
