#!/bin/bash

# location of the cnet simulator
CNET="/usr/local/bin/cnet"
export CNETPATH="/usr/local/lib/cnet"

#TOPOLOGIES="STOPANDWAIT PIGGYBACK"
TOPOLOGIES="STOPANDWAIT GOBACKN"

HTML="plot.html"

DURATION="1hour"
EVERY="10"

METRIC="Messages delivered"	; YTITLE="messages"
#METRIC="Frames transmitted"	; YTITLE="frames"
#METRIC="Average delivery time"	; YTITLE="microseconds"

TITLE="$METRIC over $DURATION"
XTITLE="seconds"

# --  nothing needs changing below this line  --------------------------

cleanup() {
    rm -f tmp.*
}

check_things() {
    if [ ! -x $CNET ]
    then
	echo "cannot find or execute $CNET"
	exit 1
    fi
    if [ ! -d $CNETPATH -o ! -r $CNETPATH ]
    then
	echo "cannot find or read directory $CNETPATH"
	exit 1
    fi
    for t in `echo $TOPOLOGIES`
    do
        if [ ! -r $t ]
        then
	    echo "cannot find or read topology file $t"
            exit 1
        fi
    done
}

run_simulations() {
    cleanup
    for t in `echo $TOPOLOGIES`
    do
        $CNET -W -q -F -e $DURATION -s -f ${EVERY}secs $t       | \
        grep -i "$METRIC"                                       | \
        cut -d: -f 2                                            | \
        awk "{ printf(\"%d %s\n\", ++i * $EVERY, \$1); }"       > tmp.$t
    done
}

collate_stats() {
    echo '      data.addRows(['

    T0=`echo " " $TOPOLOGIES | sed -e 's/ / tmp./g' | cut '-d ' -f3-`
    T1=`echo $T0 | cut '-d ' -f1`
    T2=`echo $T0 | cut '-d ' -f1,2`

    if [ "$T0" == "$T1" ]
    then
	CMD="cat $T0"
    elif [ "$T0" == "$T2" ]
    then
	CMD="join $T0"
    else
	CMD="join "`echo $T0 | cut '-d ' -f1`
	CMD="$CMD "`echo $T0 | cut '-d ' -f2- | sed 's/ / | join - /g'`
    fi

    eval $CMD | sed -e 's/ /, /g' -e 's/.*/[&],/'
    echo ']);'
}

add_titles() {
    for t in time `echo $TOPOLOGIES`
    do
        echo "      data.addColumn('number', '$t');"
    done
}

build_html() {
    cat << END_TOP_SECTION
<html>
<head>
  <script type='text/javascript' src='https://www.gstatic.com/charts/loader.js'></script>
</head>

<body>
  <script type='text/javascript'>
    google.charts.load('45', {'packages':['corechart']});

    function plot1() {
      var data = new google.visualization.DataTable();
END_TOP_SECTION

add_titles
collate_stats
cleanup

cat << END_BOTTOM_SECTION
      var options = {
	  title:  '$TITLE',
	  height: 400,
	  width:  800,
	  colors: ['blue', 'magenta'],
	  chartArea: {backgroundColor: '#f2f2f2', left:80, right:160, top:40, bottom:60},
	  lineWidth: 2,
	  hAxis: { title: '$XTITLE' },
	  vAxis: { title: '$YTITLE', format: '0', minValue: 0, gridlines: {count: 5} }
      };
      var container = document.getElementById('PLOT1');
      var chart     = new google.visualization.LineChart(container);
      chart.draw(data, options);
    }
    google.setOnLoadCallback(plot1);
  </script>

  <div id='PLOT1'></div>
</body>
</html>
END_BOTTOM_SECTION
}


rm -f $HTML
check_things
run_simulations
build_html > $HTML
chmod 644 $HTML
echo "output is in $HTML"
