#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

//  Written by Chris.McDonald@uwa.edu.au, 2023-
//  Under licence - creativecommons.org/licenses/by-nc-sa/4.0/

typedef struct _s {
    int         value;
    struct _s   *next;
}  STACKITEM;

STACKITEM    *stack = NULL;

void push_item(int newvalue)
{
    STACKITEM  *new = malloc( sizeof(STACKITEM) );  

    if(new == NULL) {     // check for insufficient memory   
        perror("push_item");
        exit(EXIT_FAILURE);
    }

    new->value   = newvalue;
    new->next    = stack;
    stack        = new;
}

int pop_item(void)
{
    STACKITEM  *old;
    int        oldvalue;

    if(stack == NULL) {
        fprintf(stderr, "attempt to pop from an empty stack\n");  
        exit(EXIT_FAILURE);
    }

    oldvalue     = stack->value;
    old          = stack;
    stack        = stack->next;
    free(old);

    return oldvalue;
}

//  ----------------------------------------------------------------

int evaluate_RPN(FILE *fp)
{
    char  line[BUFSIZ];

    while( fgets(line, sizeof line, fp) != NULL ) {  
	int   val1, val2;

        if(line[0] == '#') {
            continue;
	}
        if(isdigit(line[0]) || line[0] == '-') {
            push_item( atoi(line) );
	}
        else if(line[0] == 'a') {
            val1 = pop_item();
            val2 = pop_item();
            push_item( val1 + val2 );
        }
        else if(line[0] == 'd') {
            val1 = pop_item();
            val2 = pop_item();
            push_item( val2 / val1 );
        }
        else {
	    break;
	}
    }
    return pop_item();
}

int main(int argc, char *argv[])
{
    printf("%d\n", evaluate_RPN( stdin ) );
    return 0;
}
