/**
 * Represents a vote
 * Lyndon While, 2015
 */
public class Vote
{
    private String marks;

    public Vote(String ms)
    // Construct a vote with a given series of marks
    {
        marks = ms;
    }
    
    public boolean isFormal(String cs)
    // Return true iff this vote is formal with candidates cs
    {
        // if any candidate is missing, the vote is informal
        for (int i = 0; i < cs.length(); i++) 
            if (marks.indexOf(cs.charAt(i)) == -1) return false;
        // if all candidates are present, the vote is formal as long as there is nothing else there
        return marks.length() == cs.length();
    }
    
    public char getFirstPreference(String losers)
    // Return the preferred candidate, deleting losers only as needed
    {
        char w = marks.charAt(0);
        // if w is one of the losers, delete them and check the next one
        while (losers.indexOf(w) != -1) 
        {
            delete(w); 
            w = marks.charAt(0);
        }
        return w;
    }
    
    private void delete(char loser)
    // Delete loser from marks
    {
        marks = marks.replaceAll(String.valueOf(loser), "");
    }

}
