/**
 * Performs an election 
 * Lyndon While 2015
 */
import java.util.ArrayList;

public class Election
{
   private ArrayList<Candidate> candidates;
   private int noOfVotes;
   private String losers;
   
   public Election(String candidatesFile, String votesFile) 
   {
       losers = "";
       FileIO f;

       // read the candidates file into names 
       f = new FileIO(candidatesFile);
       String names = f.lines.get(0);
       // read the votes file and add the formal votes to votes 
       f = new FileIO(votesFile);
       int informal = 0;
       ArrayList<Vote> votes = new ArrayList<>();
       Vote v;
       for (int i = 0; i < f.lines.size(); i++) 
       {
           v = new Vote(f.lines.get(i));
           if (v.isFormal(names)) {noOfVotes++; votes.add(v);}
           else                   {informal++;}
       }
       System.out.println("There are " + informal  + " informal votes");
       System.out.println("There are " + noOfVotes + " formal votes");
    
       // add each formal vote to the appropriate candidate's pile 
       candidates = new ArrayList<>();
       Candidate c;
       for (int i = 0; i < names.length(); i++) 
       {
           c = new Candidate(names.charAt(i));
           c.addVotes(votes, losers);
           candidates.add(c);
       }
       displayCount();
   }
   
   public Election(String x)
   {
       this (x.concat("C.txt"), x.concat("V.txt"))
   ;} 
   
   public Election()
   {
       this ("L");
   } 
   
   public void nextRound()
   // Perform one round of an election
   {
       char w = winner();
       if (w == '?')
       {
           // if there's no winner, identify the loser and re-distribute their votes
           Candidate loser = findAndDeleteLoser();
           for (Candidate c : candidates) 
               c.addVotes(loser.getVotes(), losers);
           displayCount();
       }
       else System.out.println(w + " has won");
   }
   
   public void displayCount () 
   // Display the current count
   {
       int width = 1000; int border = 50; int height = 400; 
       SimpleCanvas sc = new SimpleCanvas ("Latest count", width, height);
       int yscale = (height - 2 * border) / candidates.size(); // height for each candidate
       int p = noOfVotes / 2 + 1;                              // winning post
       int w = mostVotes().getCount(); if (w < p) w = p;       // no of votes to plot
       double xscale = (width - border - yscale) / (double) w; // width for each vote
       for (int i = 0; i < candidates.size(); i++)
       {
           int x = candidates.get(i).getCount();
           for (int j = 0; j <= 1; j++)
           {
               sc.drawLine(0, border + (i+j) * yscale, (int) (x * xscale + yscale), border + (i+j) * yscale);
               sc.drawLine((int) (j * x * xscale + yscale), border + i * yscale, (int) (j * x * xscale + yscale), border + (i+1) * yscale);
           }
           int z = border + i * yscale + 3 * yscale / 5;
           sc.drawString(String.valueOf(candidates.get(i).getName()), yscale / 3, z);
           if (x > 0) sc.drawString(String.valueOf(x), (int) (Math.max(10, xscale / 2) + yscale), z);
       }
       int dashsize = 30; 
       int z = (int) (yscale + p * xscale);
       for (int y = 0; y < height; y = y + 2 * dashsize) sc.drawLine(z, y, z, y + dashsize);
       sc.drawString("winning", z + border / 10, height / 2 - 10);
       sc.drawString("post",    z + border / 10, height / 2 + 10);
   }
   
   public Candidate findAndDeleteLoser()
   // Find and delete the losing candidate
   {
       Candidate loser = fewestVotes();
       losers = losers.concat(String.valueOf(loser.getName()));
       candidates.remove(loser); 
       return loser;
    }
   
   public char winner()
   // Return the name of the winning candidate, or '?' if none
   {
       for (Candidate c : candidates)
           if (c.isWinner(noOfVotes)) return c.getName();
       return '?';
   }
   
   private Candidate fewestVotes()
   // Return the candidate with the fewest votes
   {
       Candidate k = candidates.get(0);
       for (Candidate c : candidates)
           if (c.getCount() < k.getCount()) k = c;
       return k;
   }
   
   private Candidate mostVotes()
   // Return the candidate with the most votes
   {
       Candidate k = candidates.get(0);
       for (Candidate c : candidates)
           if (c.getCount() > k.getCount()) k = c;
       return k;
   }

}
