/**
 * Represents a candidate
 * Lyndon While, 2015
 */
import java.util.ArrayList;

public class Candidate
{
    private char name; 
    private ArrayList<Vote> votes;

    public Candidate(char name)
    // Construct a candidate with no votes
    {
        this.name = name; 
        votes = new ArrayList<>(); 
    }
    
    public char getName()
    // Accessor method
    {
        return name;
    }
    
    public int getCount()
    // Accessor method
    {
        return votes.size();
    }
    
    public ArrayList<Vote> getVotes()
    // Accessor method
    {
        return votes;
    }
    
    public boolean isWinner(int noOfVotes)
    // Return true iff this candidate has won the election
    {
        return getCount() > noOfVotes / 2;
    }
    
    public void addVotes(ArrayList<Vote> papers, String losers)
    // Add the votes for this candidate from papers, discarding losers
    {
        for (Vote v : papers)
            if (v.getFirstPreference(losers) == name) 
               votes.add(v);
    }

}
